using System;
using System.Reflection;
using System.IO; 
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.RegularExpressions;
using System.Threading;
using System.Diagnostics;
using System.Runtime.Remoting;
using System.Collections;

//Wykonane celowo w 7.13 w celu pokazania sposobu przecienia operatora ==
#pragma warning disable 1718 //Porwnanie z t sam zmienn; czy chciae porna z czym innym? 

namespace CSharpRecipes
{
	public class ExceptionHandling
    {
        #region "7.1 Weryfikacja kluczowych parametrw"
        public static void TestParams(int numberOfItems, object myObject,Language language)
		{
            Debug.Assert(numberOfItems <= 100);
			if (numberOfItems > 100)
			{
				throw (new ArgumentOutOfRangeException("numberOfItems", numberOfItems,
                    "Liczba elementw przekroczya zdefiniowany limit."));
			}

            Debug.Assert(myObject != null);
            if (myObject == null)
			{
				throw (new ArgumentNullException("myObject",
                    "Przekazany obiekt nie moe mie wartoci null."));
			}

            switch (language)
            {
                // Tu naley wymieni wszystkie prawidowe wartoci typu wyliczeniowego.
                // Oznacza to, e prawidowe bd tylko te, ktre wymienimy
                // a nie wszystkie wartoci okrelonego typu wyliczeniowego
                // UWAGA: Wartoci All i VB6 dla tej metody nie s prawidowe..
                case Language.CSharp:
                case Language.Other:
                case Language.VBNET:
                    break;
                default:
                    //Debug.Assert(false, language + " nie jest prawidow wartoci typu wyliczeniowego dla tej metody.");
	    			throw (new System.ComponentModel.InvalidEnumArgumentException("language", 
		    			(int)language, typeof(Language)));
            }
		}
		#endregion

        #region "7.2 Gdzie naley przechwytywa i ponawia zgaszanie wyjtkw?"
        public static void CatchThrownException()
		{
			try
			{
				Console.WriteLine("Zewntrzna instrukcja try");
				ThrowException();
			}
			catch(Exception e)
			{
				Console.WriteLine("W zewntrznym bloku catch.   Wznowiony bd == " + e.Message);
			}
			finally
			{
				Console.WriteLine("W zewntrznym bloku finally");
			}
		}
		private static void ThrowException()
		{
			try
			{
                Console.WriteLine("Wewntrzna instrukcja try");
				int z2 = 9999999;
				checked{z2 *= 999999999;}  
			}
			catch(DivideByZeroException dbze)
			{
                // Zarejestrowanie faktu wystpienia wyjtku dzielenia przez zero.
                EventLog.WriteEntry("MyApplication", dbze.Message, EventLogEntryType.Error);
				throw;
			}
			catch(OverflowException ofe)
			{
				Console.WriteLine("Wystpio przepenienie.   Komunikat o bdzie == " + ofe.Message);
				throw;
			}
			catch(Exception e)
			{
				Console.WriteLine("Wystpi bd innego typu.   Komunikat o bdzie == " + e.Message);
				throw;
			}
			finally
			{
				Console.WriteLine("W wewntrznym bloku finally");
			}
		}
		#endregion

		#region "7.3 Gdzie zgasza okrelone wyjtki"
		// Opis znajduje si w recepturze 7.3 w treci ksiki.
		#endregion

        #region "7.4 Indywidualna obsuga pochodnych wyjtkw"
        public static void HandleDerivedExceptions()
        {
            try
            {
                int d = 0;
                int z = 1 / d;
            }
            catch (DivideByZeroException dbze)
            {
                Console.WriteLine("Wystpi bd dzielenia przez zero. Komunikat o bdzie == " + dbze.Message);
            }
            catch (OverflowException ofe)
            {
                Console.WriteLine("Wystpio przepenienie. Komunikat o bdzie == " + ofe.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine("Wystpi inny bd. Komunikat o bdzie == " + e.Message);
            }
        }
        #endregion

        #region "7.5 Jak zapewni, aby wyjtki nie byy tracone w przypadku wykorzystania blokw finally? "
        public static void PreventLossOfException()
		{
			try
			{
				Console.WriteLine("W zewntrznym bloku try");
				ReThrowException2();
			}
			catch(Exception e)
			{
				Console.WriteLine("W zewntrznym bloku catch.   Ponownie zgoszony bd == " + e.Message);
			}
			finally
			{
				Console.WriteLine("W zewntrznym bloku finally");
			}
		}

		private static void ReThrowException2()
		{
			try
			{
				Console.WriteLine("W wewntrznym bloku try");
				int z2 = 9999999;
				checked{z2 *= 999999999;}  
			}
			catch(OverflowException ofe)
			{
				Console.WriteLine("Wystpio przepenienie.   Komunikat o bdzie == " + ofe.Message);
				throw;
			}
			catch(Exception e)
			{
				Console.WriteLine("Wystpi inny bd.   Komunikat o bdzie == " + 
					e.Message);
				throw;
			}
			finally
			{
//				Console.WriteLine("W wewntrznym bloku finally");
//				throw(new Exception("Oops"));   // Symulacja zgoszenia wyjtku
				try
				{
					Console.WriteLine("W wewntrznym bloku finally");
					throw(new Exception("Oops"));
				}
				catch(Exception e)
				{
					Console.WriteLine(@"Wystpi bd w bloku finally. Komunikat o bdzie == " + e.Message);
				}
			}
		}
        #endregion

        #region "7.6 Obsuga wyjtkw zgaszanych przez metody wywoywane za pomoc odbi"
        public static void ReflectionException()
		{
			Type reflectedClass = typeof(ExceptionHandling);

			try
			{
				MethodInfo methodToInvoke = reflectedClass.GetMethod("TestInvoke");

				if (methodToInvoke != null)
				{
					object oInvoke = methodToInvoke.Invoke(null, null);
				}
			}
			catch(Exception e)
			{
                Console.WriteLine("KOMUNIKAT: " + e.Message);
                Console.WriteLine("RDO: " + e.Source);
                Console.WriteLine("METODA DOCELOWA: " + e.TargetSite);
                Console.WriteLine("STOS: " + e.StackTrace + "\r\n");
    
				if(e.InnerException != null)
				{
					Console.WriteLine();
                    Console.WriteLine("\t**** POCZTEK WEWNTRZNEGO WYJTKU ****");
                    Console.WriteLine("\tKOMUNIKAT WEWNTRZNEGO WYJTKU:  " + e.InnerException.Message);
                    Console.WriteLine("\tRDO WEWNTRZNEGO WYJTKU:  " + e.InnerException.Message);
                    Console.WriteLine("\tSTOS WEWNTRZNEGO WYJTKU:  " + e.InnerException.Message);
                    Console.WriteLine("\tMETODA DOCELOWA WEWNTRZNEGO WYJTKU:  " + e.InnerException.TargetSite);
                    Console.WriteLine("\t****    KONIEC WEWNTRZNEGO WYJTKU****");
                }

				Console.WriteLine();

                //  Wywietlenie informacji z dziennika fuzji w przypadku, gdy nie mona znale kompilata
				Console.WriteLine(e.ToString());
			}
		}
		
		public static void TestInvoke()
		{
            throw (new Exception("Zgoszony z poziomu wywoanej metody."));
		}
        #endregion

        #region "7.7 Diagnozowanie problemw podczas adowania kompilatw"
        public static void LoadMissingDLL()
        {
            // Zaadowanie biblioteki DLL.
			try
			{
				Assembly reflectedAssembly = Assembly.LoadFrom("BadFileName.dll");
			}
			catch (FileNotFoundException fnf)
			{
                // Wywietla wycznie informacje  z dziennika fuzji .
				Console.WriteLine(fnf.FusionLog);
			}
			catch (Exception e)
			{
                // Wywietlenie informacji o wyjtku razem z informacjami z 
                // dziennika fuzji.

				Console.WriteLine(e.ToString());
			}
		}
        #endregion

        #region "7.8 Odwzorowania pomidzy zarzdzanymi wyjtkami, a wartociami HRESULT"
        // Opis znajduje si w recepturze 7.8 w treci ksiki.
		#endregion

        #region "7.9 Obsuga wartoci HRESULT definiowanych przez uytkownika"
        public static void TestUDHRESULT()
		{
			try
			{
				//CallCOMMethod();
			}
			catch (System.Runtime.InteropServices.COMException ce)
			{
				switch ((uint)ce.ErrorCode)
				{
					case 0x80042000:
                        // Obsuga wyjtkw obiektw COM/COM+ zdefiniowanych przez uytkownika.
						break;
					case 0x80042001:
                        // Obsuga wyjtkw obiektw COM/COM+ zdefiniowanych przez uytkownika.
						break;
					default:
                        //  Obsuga pozostaych specyficznych wyjtkw COM/C0M+ zdefiniowanych przez uytkownika
						break;
				}
			}
			catch (Exception e)
			{
                //  Obsuga wszystkich pozostaych wyjtkw.
				Console.WriteLine(e);
			}
		}
		#endregion

        #region "7.10 Przeciwdziaanie nieobsuonym wyjtkom"
        public static void LastChanceHandler(object sender, UnhandledExceptionEventArgs args) 
		{
			Exception e = (Exception) args.ExceptionObject;

            Console.WriteLine("Nieobsuony wyjtek == " + e.ToString());
			if (args.IsTerminating)
			{
                Console.WriteLine("Aplikacja koczy dziaanie");
			}
			else
			{
                Console.WriteLine("Aplikacja nie koczy dziaania");
			}
		}

		public static void SetupLastChanceSEH()
		{
            AppDomain currentDomain = AppDomain.CurrentDomain;
            currentDomain.UnhandledException += new UnhandledExceptionEventHandler(LastChanceHandler);
    
			System.Threading.Thread.Sleep(2000);
			
			// W przypadku uruchomienia tego kodu w debuggerze, debugger przechwyci 
			// wyjtek opuszczajc zasig i zgosi go pomimo tego, e zdefiniowalimy
			// blok obsugi nieobsuonych wyjtkw.
			throw (new Exception("MyUnhandledException"));
		}
        #endregion

        #region "7.11 Uzyskiwanie informacji o wyjtkach"
        public static int exceptionLevel = 0;
		public static void DisplayException(Exception e)
		{
            // Inkrementacja poziomu wyjtku.
            exceptionLevel++;
            // Pozostawienie odstpu na poziom.
            string indent = new string('\t', exceptionLevel - 1);
            // Wywietlenie informacji o wyjtku okrelonego poziomu.
            Console.WriteLine(indent + "*** Poziom wyjtku {0} " + "**************************************", exceptionLevel);
            Console.WriteLine(indent + "ExceptionType: " + e.GetType().Name.ToString());
            Console.WriteLine(indent + "HelpLine: " + e.HelpLink);
            Console.WriteLine(indent + "Message: " + e.Message);
            Console.WriteLine(indent + "Source: " + e.Source);
            Console.WriteLine(indent + "StackTrace: " + e.StackTrace);
            Console.WriteLine(indent + "TargetSite: " + e.TargetSite);
            Console.WriteLine(indent + "Data:");
            foreach (DictionaryEntry de in e.Data)
            {
                Console.WriteLine(indent + "\t{0} : {1}", de.Key, de.Value);
            }
            // Pobranie wewntrznego wyjtku.
            Exception ie = e.InnerException;
            // Rekurencyjne wywietlanie informacji o wyjtkach wewntrznych.
            while (ie != null)
            {
                DisplayException(ie);
                // Sprawdzenie, czy wywietlono informacje o wszystkich wyjtkach wewntrznych.
                if (exceptionLevel > 1)
                    ie = ie.InnerException;
                else // powrt do gwnego poziomu
                    ie = null;
            }
            // Dekrementacja poziomu wyjtku.
            exceptionLevel--;
        }


		public static void TestDisplayException()
		{
            Exception InnerInner = new Exception("Wyjtek WewnWewn.");
            InnerInner.Data.Add("Indeks1 wyjtku WewnWewn", "Warto1 wyjtku WewnWewn");

            ArgumentException Inner = new ArgumentException("Wyjtek Wewn.", InnerInner);
            Inner.Data.Add("Indeks1 wyjtku Wewn", "Warto1 wyjtku Wewn");

            NullReferenceException se = new NullReferenceException("Komunikat testowy.", Inner);
            se.HelpLink = "MyComponent.hlp";
            se.Source = "MyComponent";
            se.Data.Add("Indeks1 wyjtku Zewn", "Warto1 wyjtku Zewn");
            se.Data.Add("Indeks2 wyjtku Zewn", "Warto2 wyjtku Zewn");
            se.Data.Add("Indeks3 wyjtku Zewn", "Warto3 wyjtku Zewn");

            try
            {
                throw (se);
            }
            catch (Exception e)
            {
                DisplayException(e);
            }
        }


		public static void DisplayInnerException(Exception e)
		{
			Console.WriteLine(e.GetBaseException().ToString());
		}
        #endregion

        #region "7.12 Jak szybko dosta si do meritum problemu?"
        public void DisplayException2(Exception e)
		{
			Console.WriteLine(e.GetBaseException().ToString());
    	}
		#endregion

        #region "7.13 Tworzenie wasnych typw opisu wyjtkw"
        public static void TestSpecializedException()
{
    // Oglny wyjtek sucy do testowania
    // wewntrznego wyjtku klasy RemoteComponentException.
    Exception inner = new Exception("Wyjtek wewntrzny");

    // Testowanie poszczeglnych konstruktorw.
    Console.WriteLine(Environment.NewLine + Environment.NewLine +
    "TESTOWANIE POSZCZEGLNYCH KONSTRUKTORW");
    RemoteComponentException se1 = new RemoteComponentException ();
    RemoteComponentException se2 = new RemoteComponentException ("Komunikat testowy dla se2");
    RemoteComponentException se3 = new RemoteComponentException ("Komunikat testowy dla se3", inner);
    RemoteComponentException se4 = new RemoteComponentException ("Komunikat testowy dla se4", "MyServer");
    RemoteComponentException se5 = new RemoteComponentException ("Komunikat testowy dla se5", inner, "MyServer");

    // Testowanie nowej waciwoci ServerName.
    Console.WriteLine(Environment. NewLine + "TESTOWANIE NOWEJ WACIWOCI SERVERNAME");
    Console.WriteLine("se1.ServerName == " + se1.ServerName);
    Console.WriteLine("se2.ServerName == " + se2.ServerName);
    Console.WriteLine("se3.ServerName == " + se3.ServerName);
    Console.WriteLine("se4.ServerName == " + se4.ServerName);
    Console.WriteLine("se5.ServerName == " + se5.ServerName);

    // Testowanie przecionej waciwoci Message.
    Console.WriteLine(Environment.NewLine + "TESTOWANIE PRZECIONEJ WACIWOCI MESSAGE");
    Console.WriteLine("se1.Message == " + se1.Message);
    Console.WriteLine("se2.Message == " + se2.Message);
    Console.WriteLine("se3.Message == " + se3.Message);
    Console.WriteLine("se4.Message == " + se4.Message);
    Console.WriteLine("se5.Message == " + se5. Message);

    // Test przecionnej metody ToString
    Console.WriteLine(Environment. NewLine + "TEST PRZECIONEJ METODY TOSTRING");
    Console.WriteLine("se1.ToString() == " + se1.ToString());
    Console.WriteLine("se2.ToString() == " + se2.ToString());
    Console.WriteLine("se3.ToString() == " + se3.ToString());
    Console.WriteLine("se4.ToString() == " + se4.ToString());
    Console.WriteLine("se5.ToString() == " + se5.ToString());

    // Test metody ToBaseString.
    Console.WriteLine(Environment.NewLine + "TEST METODY TOBASESTRING");
    Console.WriteLine("se1.ToBaseString() == " + se1.ToBaseString());
    Console.WriteLine("se2.ToBaseString() == " + se2.ToBaseString());
    Console.WriteLine("se3.ToBaseString() == " + se3.ToBaseString());
    Console.WriteLine("se4.ToBaseString() == " + se4.ToBaseString());
    Console.WriteLine("se5.ToBaseString() == " + se5.ToBaseString());

    // Test przecionego operatora ==.
    Console.WriteLine(Environment.NewLine + "TEST PRZECIONEGO OPERATORA ==");
    Console.WriteLine("se1 == se1 == " + (se1 == se1));
    Console.WriteLine("se2 == se1 == " + (se2 == se1));
    Console.WriteLine("se3 == se1 == " + (se3 == se1));
    Console.WriteLine("se4 == se1 == " + (se4 == se1));
    Console.WriteLine("se5 == se1 == " + (se5 == se1));
    Console.WriteLine("se5 == se4 == " + (se5 == se4));

    // Test przecionego operatora !=.
    Console.WriteLine(Environment.NewLine + "TEST PRZECIONEGO OPERATORA !=");
    Console.WriteLine("se1 != se1 == " + (se1 != se1));
    Console.WriteLine("se2 != se1 == " + (se2 != se1));
    Console.WriteLine("se3 != se1 == " + (se3 != se1));
    Console.WriteLine("se4 != se1 == " + (se4 != se1));
    Console.WriteLine("se5 != se1 == " + (se5 != se1));
    Console.WriteLine("se5 != se4 == " + (se5 != se4));

    // Test przecionej metody GetBaseException.
    Console.WriteLine(Environment.NewLine + "TEST PRZECIONEJ METODY GETBASEEXCEPTION");
    Console.WriteLine("se1.GetBaseException() == " + se1.GetBaseException());
    Console.WriteLine("se2.CetBaseException() == " + se2.GetBaseException());
    Console.WriteLine("se3.CetBaseException() == " + se3.GetBaseException());
    Console.WriteLine("se4.GetBaseException() == " + se4.GetBaseException());
    Console.WriteLine("se5.GetBaseException() == " + se5.GetBaseException());

    // Test przecionej metody GetHashCode.
    Console.WriteLine (Environment. NewLine + "TEST PRZECIONEJ METODY GETHASHCODE");
    Console.WriteLine("se1.GetHashCode() == " + se1.GetHashCode());
    Console.WriteLine("se2.GetHashCode() == " + se2.GetHashCode());
    Console.WriteLine("se3.GetHashCode() == " + se3.GetHashCode());
    Console.WriteLine("se4.GetHashCode() == " + se4.GetHashCode());
    Console.WriteLine("se5.GetHashCode() == " + se5.GetHashCode());

    // Test serializacji.
    Console.WriteLine(Environment.NewLine + "TEST SERIALIZACJI/DESERIALIZACJI");
    BinaryFormatter binaryWrite = new BinaryFormatter();
    Stream ObjectFile = File.Create("se1.object");
    binaryWrite.Serialize(ObjectFile, se1);
    ObjectFile.Close();
    ObjectFile =  File.Create("se2.object");
    binaryWrite.Serialize(ObjectFile, se2);
    ObjectFile.Close();
    ObjectFile = File.Create("se3.object");
    binaryWrite.Serialize(ObjectFile, se3);
    ObjectFile.Close();
    ObjectFile = File.Create("se4.object");
    binaryWrite.Serialize(ObjectFile, se4);
    ObjectFile.Close();
    ObjectFile = File.Create("se5.object");
    binaryWrite.Serialize(ObjectFile, se5);
    ObjectFile.Close();
    BinaryFormatter binaryRead = new BinaryFormatter();
    ObjectFile = File.OpenRead("se1.object");
    object Data = binaryRead.Deserialize(ObjectFile);
    Console.WriteLine("--------" + Environment.NewLine + Data);
    ObjectFile.Close();
    ObjectFile = File.OpenRead("se2.object");
    Data = binaryRead.Deserialize(ObjectFile);
    Console.WriteLine("--------" + Environment.NewLine + Data);
    ObjectFile.Close();
    ObjectFile = File.OpenRead("se3.object");
    Data = binaryRead.Deserialize(ObjectFile);
    Console.WriteLine("--------" + Environment.NewLine + Data);
    ObjectFile.Close();
    ObjectFile = File.OpenRead("se4.object");
    Data = binaryRead.Deserialize(ObjectFile);
    Console.WriteLine("--------" + Environment.NewLine + Data);
    ObjectFile.Close();
    ObjectFile = File.OpenRead("se5.object");
    Data = binaryRead.Deserialize(ObjectFile);
    Console.WriteLine("--------" + Environment. NewLine + Data + Environment. NewLine + "--------");
    ObjectFile.Close();
    Console.WriteLine(Environment.NewLine + "KONIEC TESTU" + Environment.NewLine);
}


        [SerializableAttribute]
        public class RemoteComponentException : Exception, ISerializable
        {
            // Nowy wyjtek  pole
            private string serverName = "";

            // Konstruktory zwykych wyjtkw
            public RemoteComponentException()
                : base()
            {
            }

            public RemoteComponentException(string message)
                : base(message)
            {
            }

            public RemoteComponentException(string message, Exception innerException)
                : base(message, innerException)
            {
            }

            // Konstruktory wyjtkw pobierajce parametr new ServerName
            public RemoteComponentException(string message, string serverName)
                : base(message)
            {
                this.serverName = serverName;
            }

            public RemoteComponentException(string message, Exception innerException, string serverName)
                : base(message, innerException)
            {
                this.serverName = serverName;
            }

            // Konstruktor serializacji
            public RemoteComponentException(SerializationInfo exceptionInfo, StreamingContext exceptionContext)
                : base(exceptionInfo, exceptionContext)
            {
                this.serverName = exceptionInfo.GetString("ServerName");
            }

            // Waciwo tylko do odczytu
            public string ServerName
            {
                get { return (serverName.Trim()); }
            }

            public override string Message
            {
                get
                {
                    if (this.ServerName.Length == 0)
                        return (base.Message + Environment.NewLine + "Wystpi bd na nieznanym serwerze.");
                    else
                        return (base.Message + Environment.NewLine + "Wystpi bd na serwerze " + this.ServerName);
                }
            }

            // Metody przecione
            // Metoda ToString

            public override string ToString()
            {
                string errorString = "Wystpi bd " + "komponentu serwera tego klienta.";
                errorString += Environment.NewLine + "Nazwa serwera: " + this.ServerName;
                if (this.InnerException == null)
                {
                    errorString += Environment.NewLine + "Komponent serwera nie dostarczy " + "odpowiedniego wyjtku!";
                }
                else
                {
                    string indent = "\t";
                    Exception ie = this;
                    while (ie.InnerException != null)
                    {
                        ie = ie.InnerException;
                        errorString += Environment.NewLine + indent + "wewntrzny wyjtek zgoszony przez komponent serwera: " + ie.GetType().Name.ToString();
                        errorString += Environment.NewLine + indent + "Message: " + ie.Message; 
                        errorString += Environment.NewLine + indent + "StackTrace: " + ie.StackTrace;
                        indent += "\t";
                    }
                }
                errorString += Environment.NewLine + "StackTrace komponentu " + "klienta: " + this.StackTrace;
                return (errorString);
            }

            // Wywoanie metody base.ToString.
            public string ToBaseString()
            {
                return (base.ToString());
            }

            // GetHashCode
            public override int GetHashCode()
            {
                return (ServerName.GetHashCode());
            }

            // Equals
            public override bool Equals(object obj)
            {
                bool isEqual = false;
                if (obj == null || (this.GetType() != obj.GetType()))
                {
                    isEqual = false;
                }
                else
                {
                    RemoteComponentException se = (RemoteComponentException)obj;
                    if ((this.ServerName.Length == 0) && (se.ServerName.Length == 0))
                        isEqual = false;
                    else
                        isEqual = (this.ServerName == se.ServerName);
                }
                return (isEqual);
            }

            // operator == 
            public static bool operator ==(RemoteComponentException v1, RemoteComponentException v2)
            {
                return (v1.Equals(v2));
            }

            // operator !=
            public static bool operator !=(RemoteComponentException v1, RemoteComponentException v2)
            {
                return (!(v1 == v2));
            }
            // Metoda wykorzystywana podczas deserializacji do przechwytywania informacji o polach dodatkowych
            public override void GetObjectData(SerializationInfo exceptionInfo, StreamingContext exceptionContext)
            {
                base.GetObjectData(exceptionInfo, exceptionContext);
                exceptionInfo.AddValue("ServerName", this.ServerName);
            }
        }

		#endregion

        #region "7.14 Odczytywanie obrazu stosu"
        public static string GetStackTraceInfo(string currentStackTrace)
		{
			string firstStackTraceCall = "System.Environment.get_StackTrace()";
			int posOfStackTraceCall = currentStackTrace.IndexOf(firstStackTraceCall);
			return (currentStackTrace.Substring(posOfStackTraceCall + firstStackTraceCall.Length));
		}
		
		public static int GetStackTraceDepth(string currentStackTrace)
		{
			string firstStackTraceCall = "System.Environment.get_StackTrace()";
			int posOfStackTraceCall = currentStackTrace.IndexOf(firstStackTraceCall);
			string finalStackTrace = currentStackTrace.Substring(posOfStackTraceCall + firstStackTraceCall.Length);
			
			MatchCollection methodCallMatches = Regex.Matches(finalStackTrace, @"\sat\s.*(\sin\s.*\:line\s\d*)?");
			return (methodCallMatches.Count);
		}
        #endregion

        #region "7.15 Ustawienie puapki w miejscu, gdzie moe wystpi wyjtek pierwszej szansy"
        // Opis znajduje si w recepturze 7.15 w treci ksiki.
		#endregion

        #region "7.16 Zapobieganie wyjtkowi TypeInitializationException"
        public static void TestTypeInitFailure()
		{
			try
			{
                // Powoduje zgoszenie wyjtku TypeInitializationException
                TestInit c = new TestInit();

                // Zastpienie kodu tej metody wierszem zamieszczonym poniej
                // spowoduje uzyskanie podobnych wynikw.
                //TestInit.one.ToString();

			}
			catch(Exception e)
			{
                Console.WriteLine("PRZECHWYCONO WYJTEK W KONSTRUKTORZE: " + e.ToString());
			}
		}


		//	public class TestInit
		//	{
		//		public static object one = null;
		//		public static string two = one.ToString();
		//	}
		public class TestInit
		{
            public static object one = null;
            public static string two = one.ToString( );

            //static TestInit()
            //{
            //    // Dodanie tych dwch linijek eliminuje problem nieobsuonego wyjtku
            //    //    i pomaga w ledzeniu bdu.
            //    try
            //    {
            //        one = null;
            //        two = one.ToString();
            //    }
            //    catch (Exception e)
            //    {
            //        Console.WriteLine("PRZECHWYCONO WYJTEK W KONSTRUKTORZE: " + e.ToString());
            //    }
            //}

			//public static object one;
			//public static string two;
		}
		#endregion

        #region "7.17 Obsuga wyjtkw zgaszanych przez asynchroniczne delegaty"
        public static void TestPollingAsyncDelegate()
		{
			AsyncInvoke MI = new AsyncInvoke(TestAsyncInvoke.Method1);
			IAsyncResult AR = MI.BeginInvoke(null, null);
			
			while (!AR.IsCompleted)
			{
				System.Threading.Thread.Sleep(100);
				Console.Write('.');
			}
            Console.WriteLine("\r\n\r\nZakoczono odpytywanie...");
			
            //try
            //{
            //    int RetVal = MI.EndInvoke(AR);
            //    Console.WriteLine("RetVal (Polling): " + RetVal);
            //}
            //catch (Exception e)
            //{
            //    Console.WriteLine(e.ToString());
            //}
		}
		
		
		public delegate int AsyncInvoke();
		public class TestAsyncInvoke
		{
			public static int Method1()
			{
				//throw (new Exception("Method1"));
							Console.WriteLine("Wywoano Method1");
							return (1);
			}
		}
		#endregion

        #region "7.18 Przekazywanie do wyjtkw dodatkowych informacji za porednictwem pola Exception.Data"
        public static void TestExceptionData()
        {
            try
            {
                try
                {
                    try
                    {
                        try
                        {
                            ArgumentException irritable =
                                new ArgumentException("To jest irytujcy wyjtek!");
                            irritable.Data["Cause"]="Komputer uleg awarii";
                            irritable.Data["Length"]=10;
                            throw irritable;
                        }
                        catch (Exception e)
                        {
                            // Sprawdzenie, czy mona temu zaradzi...
                            if(e.Data.Contains("Cause"))
                                e.Data["Cause"] = "Komputer naprawiono";
                            throw;
                        }
                    }
                    catch (Exception e)
                    {
                        e.Data["Comment"] = "Zawsze jeste naburmuszony";
                        throw;
                    }
                }
                catch (Exception e)
                {
                    e.Data["Reassurance"] = "Bd obsuono";
                    throw;
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Dane pomocnicze opisu wyjtku:");
                foreach(DictionaryEntry de in e.Data)
                {
                    Console.WriteLine("\t{0} : {1}",de.Key,de.Value);
                }
            }
        }
		#endregion

        #region "7.19 Prezentacja wyjtkw w niestandardowy sposb za pomoc wizualizatorw"
        // Zobacz projekt ExceptionalVisualizer
		#endregion

        #region "7.20 Postpowanie z nieobsuonymi wyjtkami w aplikacjach WinForms"
        // Zobacz projekt UnhandledThreadExceptions
		#endregion
	}
}
